﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using VIRP.CRS.BO;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class PatientWorkflows : EfrBasePage
    {
        private const string DateFormat = "M/d/yyyy";

        private readonly PatientImagingManager PatientImagingManager;
        private IMAGE_ANALYSIS ImageAnalysis;
        private int PatientId;

        private const int BioWorkflowId = 12;
        private const int FragWorkflowId = 13;
        private const int LabKitId = 1;
        private const int QuestionnaireId = 2;
        private const int LabOrderId = 3;
        private const int LabResultId = 4;
        private const int InterpAndDiagId = 22;

        public PatientWorkflows()
        {
            PatientImagingManager = new PatientImagingManager();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (int.TryParse(Request.QueryString["patientId"], out PatientId))
                {
                    var patientSummary = GetOrStorePatientSummary();
                    if (patientSummary != null)
                        ImageAnalysis = PatientImagingManager.GetPatientImageAnalysis(CurrentUser, CurrentRegistryId, patientSummary.Icn);

                    PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, PatientId);

                    if (p != null)
                    {
                        ReplacePageTitle("Patients > Patient Lookup > Workflows > " + p.FULL_NAME);
                    }
                }

                SetupCommonDataSourceParameters();
            }
        }

        protected string ImagingDateReviewed
        {
            get
            {
                if (ImageAnalysis != null && ImageAnalysis.DATE_REVIEWED.HasValue)
                    return ImageAnalysis.DATE_REVIEWED.Value.ToString(DateFormat);
                return string.Empty;
            }
        }

        protected string GroupingText(object referralId, object referralStatus)
        {
            return "Referral&nbsp;#&nbsp;" 
                + BaseCode.Helpers.AntiXssEval(Convert.ToString(referralId)) 
                + "&nbsp;(" + BaseCode.Helpers.AntiXssEval(Convert.ToString(referralStatus)) 
                + ")&nbsp;";
        }

        protected string GroupingText(object caseType, object caseId, object caseStatus)
        {
            return BaseCode.Helpers.AntiXssEval(Convert.ToString(caseType))
                + "&nbsp;#&nbsp;" 
                + BaseCode.Helpers.AntiXssEval(Convert.ToString(caseId))
                + "&nbsp;(" 
                + BaseCode.Helpers.AntiXssEval(Convert.ToString(caseStatus))
                + ")&nbsp;";
        }

        protected string ImagingFragmentVerified
        {
            get
            {
                if (ImageAnalysis != null && ImageAnalysis.FRAGMENT_VERIFIED_FLAG.HasValue)
                    return ImageAnalysis.FRAGMENT_VERIFIED_FLAG.Value ? "Yes" : "No";
                return string.Empty;
            }
        }

        private void SetupCommonDataSourceParameters()
        {
            EFRPatientReferrals.DataSource = REFERRALManager.SelectByPatientId(CurrentUser, CurrentRegistryId, PatientId);
            EFRPatientReferrals.DataBind();

            var currentUser = HttpContext.Current.User.Identity.Name;
        }

        protected void EFRPatientReferrals_ItemCreated(object source, RepeaterItemEventArgs e)
        {
        }

        protected void EFRPatientReferrals_DataBound(object source, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                Repeater ReferralCasesRepeater = (Repeater)e.Item.FindControl("ReferralCases");
                if (ReferralCasesRepeater != null)
                {
                    var rId = ((ReferralsGetListByPatientResult)e.Item.DataItem).ReferralId;

                    ReferralCasesRepeater.DataSource = REFERRALManager.GetCasesByReferralId(CurrentUser, CurrentRegistryId, rId);
                    ReferralCasesRepeater.DataBind();
                }

                var item = e.Item.DataItem as ReferralsGetListByPatientResult; 

                if (item != null)
                {
                    if (item.ContactLogsCount == 0)
                    {
                        Button btnContacts = e.Item.FindControl("btnContacts") as Button;
                        if (btnContacts != null)
                        {
                            btnContacts.Enabled = false;
                        }
                    }

                    var numFragFiles = GetFragmentFilesCount(item.PatientId);

                    Button buttonDoDFragment = e.Item.FindControl("ButtonViewDoDFragment") as Button;
                    Button buttonDoDFragmentRawData = e.Item.FindControl("ButtonViewDoDFragmentRawData") as Button;

                    var authorized = UserSession.IsRegistryAdministrator || UserSession.IsRegistryUpdate;
                    if (authorized && numFragFiles != DBNull.Value && Convert.ToInt32(numFragFiles) > 0)
                    {
                        if (buttonDoDFragment != null && buttonDoDFragmentRawData != null)
                        {
                            buttonDoDFragment.Enabled = true;
                            buttonDoDFragmentRawData.Enabled = true;
                        }
                    }
                    else
                    {
                        if (buttonDoDFragment != null && buttonDoDFragmentRawData != null)
                        {
                            buttonDoDFragment.Enabled = false;
                            buttonDoDFragmentRawData.Enabled = false;
                        }
                    }

                    Label lblNoWorkflows = e.Item.FindControl("labelNoWorkflows") as Label;
                    if (lblNoWorkflows != null)
                    {
                        if (((ReferralsGetListByPatientResult)e.Item.DataItem).ReferralWorkflowCount == 0)
                        {
                            lblNoWorkflows.Visible = true;
                        }
                        else
                        {
                            lblNoWorkflows.Visible = false;
                        }
                    }
                }
            }
        }

        private object GetFragmentFilesCount(int patientId)
        {
            return VIRP.EFR.BLL.REFERRALManager.GetFragmentFileCount(CurrentUser, CurrentRegistryId, patientId);
        }

        protected void ReferralCases_DataBound(object source, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                GridView GridViewReferralActivities = (GridView)e.Item.FindControl("GridViewReferralActivities");
                if (GridViewReferralActivities != null)
                {
                    GridViewReferralActivities.DataSource =
                        REFERRALManager.SelectByCaseId(CurrentUser, CurrentRegistryId, ((ReferralCase)e.Item.DataItem).CaseId, ((ReferralCase)e.Item.DataItem).CaseTypeId);
                    GridViewReferralActivities.DataBind();
                }
            }
        }

        protected void EFRPatientReferrals_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            HiddenField hiddenID = (HiddenField)e.Item.FindControl("ReferralIDField");
            HiddenField hiddenPatientID = (HiddenField)e.Item.FindControl("HiddenFieldPatientId");
            string id = hiddenID.Value;

            if (e.CommandName.Equals("Referral"))
                Response.Redirect(string.Format("~/Custom/EFR/Referrals/Referral.aspx?referralId={0}&from=workFlow", id));
            else if (e.CommandName.Equals("ContactLogs"))
                Response.Redirect(string.Format("~/Custom/EFR/Referrals/ReferralContactLog.aspx?referralId={0}", id));
            else if (e.CommandName.Equals("ViewDoDFragment"))
                Response.Redirect(string.Format("~/Custom/EFR/DoDFragment/DoDFragment.aspx?patientId={0}", hiddenPatientID.Value));
            else if (e.CommandName.Equals("ViewDoDFragmentRawData"))
                Response.Redirect(string.Format("~/Custom/EFR/DoDFragment/DoDFragmentRawData.aspx?patientId={0}", hiddenPatientID.Value));
        }

        protected void ReferralActivities_RowCommand(object source, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "ActivityDetails")
            {
                int index = Convert.ToInt32(e.CommandArgument);

                GridView gv = source as GridView;
                if (gv != null)
                    gv.SelectedIndex = index;
                
                string activityId = string.Empty;
                string typeId = string.Empty;
                string caseTypeId = string.Empty;
                string caseId = string.Empty;

                if (gv != null)
                {
                    activityId = gv.SelectedDataKey.Values["CaseActivityId"].ToString();
                    typeId = gv.SelectedDataKey.Values["CaseActivityTypeId"].ToString();
                    caseTypeId = ((HiddenField)gv.NamingContainer.FindControl("CaseTypeIDField")).Value;
                    caseId = ((HiddenField)gv.NamingContainer.FindControl("CaseIdField")).Value;                   
                }

                if (int.Parse(typeId) == LabKitId)
                {
                    Response.Redirect(string.Format("~/Custom/EFR/LabKits/LabKitDetails.aspx?ActivityId={0}", activityId), false);
                }
                else if (int.Parse(typeId) == QuestionnaireId)
                {
                    Response.Redirect(string.Format("~/Custom/EFR/Questionnaires/SurveyLink.aspx?activityId={0}", activityId), false);
                }
                else if (int.Parse(typeId) == LabOrderId)
                {
                    if (int.Parse(caseTypeId) == BioWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/LabOrders/LabOrder.aspx?ActivityId={0}", activityId), false);
                    else if (int.Parse(caseTypeId) == FragWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/LabResults/FragLabOrder.aspx?activityId={0}", activityId), false);
                }
                else if (int.Parse(typeId) == LabResultId)
                {
                    if (int.Parse(caseTypeId) == BioWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/LabResults/LabResultDetails.aspx?activityId={0}", activityId), false);
                    else if (int.Parse(caseTypeId) == FragWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/LabResults/FragLabResultDetails.aspx?activityId={0}", activityId), false);
                }
                else if (int.Parse(typeId) == InterpAndDiagId)
                {
                    if (int.Parse(caseTypeId) == BioWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/InterpretationAndFollowUp/BioLabInterpretation.aspx?CaseId={0}", caseId), false);
                    else if (int.Parse(caseTypeId) == FragWorkflowId)
                        Response.Redirect(string.Format("~/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretation.aspx?CaseId={0}", caseId), false);
                }
            }
        }

        protected string BioFollowUpText(object followups)
        {
            StringBuilder sb = new StringBuilder();

            if (followups is List<WKF_CASE_ACTIVITY>)
            {
                List<WKF_CASE_ACTIVITY> reminderList = followups as List<WKF_CASE_ACTIVITY>;
                if (reminderList != null)
                {
                    foreach (var elem in reminderList)
                    {
                        if (elem.FOLLOWUP_PLAN_DATE.HasValue)
                        {
                            sb.Append("This Referral needs Follow Up Biomonitoring, due " + elem.FOLLOWUP_PLAN_DATE.Value.ToString("d"));
                        }
                    }
                }
            }
            return sb.ToString();
        }

        protected string SelectContactText(object count)
        {
            if (int.Parse(count.ToString()) == 0)
                return "&nbsp;This referral has no contact entries.";
            else if (int.Parse(count.ToString()) == 1)
                return "&nbsp;This referral has 1 contact entry.";
            else
                return "&nbsp;This referral has&nbsp;" + int.Parse(count.ToString()) + "&nbsp;contact entries.";
        }

        protected string OutOfThisText(object count)
        {
            if (int.Parse(count.ToString()) == 1)
                return "&nbsp;Out of this&nbsp;" + Eval("ContactLogsCount") + "&nbsp;contact entry,&nbsp;";
            else
                return "&nbsp;Out of these&nbsp;" + Eval("ContactLogsCount") + "&nbsp;contact entries,&nbsp;";
        }

        protected string NeedText(object count)
        {
            if (int.Parse(count.ToString()) == 1)
                return "needs";
            else
                return "need";
        }

        /// <summary>
        /// //Added for 508 compliance with GridView column headers and footer
        /// </summary>
        protected void GridViewReferralActivities_DataBound(object sender, EventArgs e)
        {
            var grid = sender as GridView;
            if (grid != null)
                Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + grid.ClientID + "');", true);
        }

        protected void LinkButtonPatientInformation_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out PatientId))
                Response.Redirect(String.Format("~/Custom/EFR/Patients/Patient.aspx?PatientId={0}", PatientId));
        }

        protected void LinkButtonRelatedDiagnoses_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out PatientId))
                Response.Redirect(String.Format("~/Custom/EFR/Patients/PatientRelatedDiagnoses.aspx?PatientId={0}", PatientId));
        }

        protected void LinkButtonLabTests_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out PatientId))
                Response.Redirect(String.Format("~/Custom/EFR/Patients/PatientRelatedLabTests.aspx?PatientId={0}", PatientId));
        }

        protected void LinkButtonImages_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out PatientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientImaging.aspx?PatientId={0}", PatientId));
        }
    }
}